USE [CRS]

GO
/****** Object:  StoredProcedure [CRS].[usp_ALLERGY_getitemsByReferral]    Script Date: 12/6/2017 12:57:41 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO



-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all Allergy records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_ALLERGY_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_ALLERGY_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[ALLERGY].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[ALLERGY] ON [CRS].[ALLERGY].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




GO
/****** Object:  StoredProcedure [CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral]    Script Date: 12/6/2017 1:03:45 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_AUDIOMETRIC_EXAM_DATA_509850_9 records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_AUDIOMETRIC_EXAM_DATA_509850_9].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_AUDIOMETRIC_EXAM_DATA_509850_9] ON [CRS].[A06_AUDIOMETRIC_EXAM_DATA_509850_9].[ROW_ID] = [CRS].[sPATIENT].[PatientIEN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END





GO
/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral]    Script Date: 12/6/2017 1:05:04 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_PHARMACY_PATIENT_55X_IV_55_01 records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_PHARMACY_PATIENT_55X_IV_55_01].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_PHARMACY_PATIENT_55X_IV_55_01] ON [CRS].[A06_PHARMACY_PATIENT_55X_IV_55_01].[PHARMACY_PATIENT] = [CRS].[sPATIENT].[PatientIEN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END



GO
/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral]    Script Date: 12/6/2017 1:06:57 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_PHARMACY_PATIX_UNIT_DOSE_55_06 records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_PHARMACY_PATIX_UNIT_DOSE_55_06].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_PHARMACY_PATIX_UNIT_DOSE_55_06] ON [CRS].[A06_PHARMACY_PATIX_UNIT_DOSE_55_06].[PHARMACY_PATIENT] = [CRS].[sPATIENT].[PatientIEN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END



GO
/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral]    Script Date: 12/6/2017 1:08:00 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_PHARMACY_PATX_NONVA_MEDS_55_05 records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_PHARMACY_PATX_NONVA_MEDS_55_05].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_PHARMACY_PATX_NONVA_MEDS_55_05] ON [CRS].[A06_PHARMACY_PATX_NONVA_MEDS_55_05].[PHARMACY_PATIENT] = [CRS].[sPATIENT].[PatientIEN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END





GO
/****** Object:  StoredProcedure [CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral]    Script Date: 12/6/2017 1:09:18 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_SPATIENT_GEOCODEDADDRESS records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_SPATIENT_GEOCODEDADDRESS].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_SPATIENT_GEOCODEDADDRESS] ON [CRS].[A06_SPATIENT_GEOCODEDADDRESS].[PatientICN] = [CRS].[sPATIENT].[PatientICN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







GO
/****** Object:  StoredProcedure [CRS].[usp_CHEM_LABCHEM_getitemsByReferral]    Script Date: 12/6/2017 1:10:21 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO




-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all CHEM_LABCHEM records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_CHEM_LABCHEM_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_CHEM_LABCHEM_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[CHEM_LABCHEM].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[CHEM_LABCHEM] ON [CRS].[CHEM_LABCHEM].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







GO
/****** Object:  StoredProcedure [CRS].[usp_Consult_getitemsByReferral]    Script Date: 12/6/2017 1:12:13 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO




-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all Consult records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_Consult_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_Consult_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[Consult].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[Consult] ON [CRS].[Consult].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




GO
/****** Object:  StoredProcedure [CRS].[usp_EDISLOG_getitemsByReferral]    Script Date: 12/6/2017 1:13:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO






-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all EDISLOG records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_EDISLOG_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_EDISLOG_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[EDISLOG].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[EDISLOG] ON [CRS].[EDISLOG].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







GO
/****** Object:  StoredProcedure [CRS].[usp_Immunization_getitemsByReferral]    Script Date: 12/6/2017 1:17:18 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all Immunization records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_Immunization_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_Immunization_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[Immunization].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[Immunization] ON [CRS].[Immunization].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






GO
/****** Object:  StoredProcedure [CRS].[usp_INPAT_CENSUS_getitemsByReferral]    Script Date: 12/6/2017 1:18:04 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all INPAT_CENSUS records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_INPAT_CENSUS_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_INPAT_CENSUS_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[INPAT_CENSUS].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[INPAT_CENSUS] ON [CRS].[INPAT_CENSUS].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




GO
/****** Object:  StoredProcedure [CRS].[usp_INPAT_INPATIENT_getitemsByReferral]    Script Date: 12/6/2017 1:19:02 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO






-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all INPAT_INPATIENT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_INPAT_INPATIENT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_INPAT_INPATIENT_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[INPAT_INPATIENT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[INPAT_INPATIENT] ON [CRS].[INPAT_INPATIENT].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






GO
/****** Object:  StoredProcedure [CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral]    Script Date: 12/6/2017 1:20:03 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all INPATIENT_DIAGNOSIS records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_INPATIENT_DIAGNOSIS_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[INPATIENT_DIAGNOSIS].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[INPATIENT_DIAGNOSIS] ON [CRS].[INPATIENT_DIAGNOSIS].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






GO
/****** Object:  StoredProcedure [CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral]    Script Date: 12/6/2017 1:20:55 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all MILITARY_SERVICE_EPISODE records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_MILITARY_SERVICE_EPISODE_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[MILITARY_SERVICE_EPISODE].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[MILITARY_SERVICE_EPISODE] ON [CRS].[MILITARY_SERVICE_EPISODE].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






GO
/****** Object:  StoredProcedure [CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral]    Script Date: 12/6/2017 1:21:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all MILITARY_SEXUAL_TRAUMA records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[MILITARY_SEXUAL_TRAUMA].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[MILITARY_SEXUAL_TRAUMA] ON [CRS].[MILITARY_SEXUAL_TRAUMA].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END








GO
/****** Object:  StoredProcedure [CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral]    Script Date: 12/6/2017 1:22:41 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all NOSETHROAT_RADIUMHST records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_NOSETHROAT_RADIUMHST_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[NOSETHROAT_RADIUMHST].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[NOSETHROAT_RADIUMHST] ON [CRS].[NOSETHROAT_RADIUMHST].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







GO
/****** Object:  StoredProcedure [CRS].[usp_OEFOIF_SERVICE_getitemsByReferral]    Script Date: 12/6/2017 1:23:29 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all OEFOIF_SERVICE records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_OEFOIF_SERVICE_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_OEFOIF_SERVICE_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[OEFOIF_SERVICE].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[OEFOIF_SERVICE] ON [CRS].[OEFOIF_SERVICE].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END





GO
/****** Object:  StoredProcedure [CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral]    Script Date: 12/6/2017 1:24:26 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all OUTPAT_PROBLEMLIST records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_OUTPAT_PROBLEMLIST_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[OUTPAT_PROBLEMLIST].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[OUTPAT_PROBLEMLIST] ON [CRS].[OUTPAT_PROBLEMLIST].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END









GO
/****** Object:  StoredProcedure [CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral]    Script Date: 12/6/2017 1:25:51 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all OUTPAT_VDIAGNOSIS records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_OUTPAT_VDIAGNOSIS_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[OUTPAT_VDIAGNOSIS].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[OUTPAT_VDIAGNOSIS] ON [CRS].[OUTPAT_VDIAGNOSIS].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END








GO
/****** Object:  StoredProcedure [CRS].[usp_OUTPAT_VISIT_getitemsByReferral]    Script Date: 12/6/2017 1:26:37 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all OUTPAT_VISIT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_OUTPAT_VISIT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_OUTPAT_VISIT_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[OUTPAT_VISIT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[OUTPAT_VISIT] ON [CRS].[OUTPAT_VISIT].[PATIENTIEN] = [CRS].[sPATIENT].[PatientIEN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END








/****** Object:  StoredProcedure [CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral]    Script Date: 12/6/2017 1:27:25 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PATIENT_ENROLLMENT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_PATIENT_ENROLLMENT_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATIENT_ENROLLMENT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PATIENT_ENROLLMENT] ON [CRS].[PATIENT_ENROLLMENT].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




GO
/****** Object:  StoredProcedure [CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral]    Script Date: 12/6/2017 1:28:36 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PATIENT_ETHNICITY records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_PATIENT_ETHNICITY_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATIENT_ETHNICITY].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PATIENT_ETHNICITY] ON [CRS].[PATIENT_ETHNICITY].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END








GO
/****** Object:  StoredProcedure [CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral]    Script Date: 12/6/2017 1:29:44 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PATSUB_SECONDARYELIGIBILITY records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATSUB_SECONDARYELIGIBILITY].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PATSUB_SECONDARYELIGIBILITY] ON [CRS].[PATSUB_SECONDARYELIGIBILITY].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






GO
/****** Object:  StoredProcedure [CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral]    Script Date: 12/6/2017 1:30:36 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PATSUB_VARATEDDISABILITY records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_PATSUB_VARATEDDISABILITY_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATSUB_VARATEDDISABILITY].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PATSUB_VARATEDDISABILITY] ON [CRS].[PATSUB_VARATEDDISABILITY].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






GO
/****** Object:  StoredProcedure [CRS].[usp_PHARMACY_PATIENT_getitemsByReferral]    Script Date: 12/6/2017 1:31:31 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PHARMACY_PATIENT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PHARMACY_PATIENT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_PHARMACY_PATIENT_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PHARMACY_PATIENT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PHARMACY_PATIENT] ON [CRS].[PHARMACY_PATIENT].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







GO
/****** Object:  StoredProcedure [CRS].[usp_RADIOLOGYEXAM_getitemsByReferral]    Script Date: 12/6/2017 1:32:16 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all RADIOLOGYEXAM records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_RADIOLOGYEXAM_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_RADIOLOGYEXAM_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[RADIOLOGYEXAM].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[RADIOLOGYEXAM] ON [CRS].[RADIOLOGYEXAM].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







GO
/****** Object:  StoredProcedure [CRS].[usp_RXOUTPAT_getitemsByReferral]    Script Date: 12/6/2017 1:33:18 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all RXOUTPAT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_RXOUTPAT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_RXOUTPAT_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[RXOUTPAT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[RXOUTPAT] ON [CRS].[RXOUTPAT].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END











GO
/****** Object:  StoredProcedure [CRS].[usp_SCONSULT_REASON_getitemsByReferral]    Script Date: 12/6/2017 1:34:11 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO




-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all SCONSULT_REASON records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_SCONSULT_REASON_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_SCONSULT_REASON_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[SCONSULT_REASON].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[SCONSULT_REASON] ON [CRS].[SCONSULT_REASON].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END












GO
/****** Object:  StoredProcedure [CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral]    Script Date: 12/6/2017 1:35:11 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all SERVICE_CONNECTED_CONDITION records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[SERVICE_CONNECTED_CONDITION].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[SERVICE_CONNECTED_CONDITION] ON [CRS].[SERVICE_CONNECTED_CONDITION].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




GO
/****** Object:  StoredProcedure [CRS].[usp_SPATIENT_NEW_getitemsByReferral]    Script Date: 12/6/2017 1:36:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all SPATIENT_NEW records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_SPATIENT_NEW_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_SPATIENT_NEW_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[SPATIENT_NEW].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[SPATIENT_NEW] ON [CRS].[SPATIENT_NEW].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END








GO
/****** Object:  StoredProcedure [CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral]    Script Date: 12/6/2017 1:37:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all SPATIENT_SPATIENTINSURANCE records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[SPATIENT_SPATIENTINSURANCE].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[SPATIENT_SPATIENTINSURANCE] ON [CRS].[SPATIENT_SPATIENTINSURANCE].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






GO
/****** Object:  StoredProcedure [CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral]    Script Date: 12/6/2017 1:39:30 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all TIU_TIUDOCUMENT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_TIU_TIUDOCUMENT_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[TIU_TIUDOCUMENT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[TIU_TIUDOCUMENT] ON [CRS].[TIU_TIUDOCUMENT].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






GO
/****** Object:  StoredProcedure [CRS].[usp_VITALSIGN_getitemsByReferral]    Script Date: 12/6/2017 1:39:30 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all VITALSIGN records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_VITALSIGN_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_VITALSIGN_getitemsByReferral', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[VITALSIGN].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[VITALSIGN] ON [CRS].[VITALSIGN].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END
















































































































































































